/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rbf.impl;

import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.rbf.impl.HandlerManager;
import com.ibm.hwmca.fw.rbf.impl.HandlersReply;
import com.ibm.hwmca.fw.rbf.impl.RbfMsg;
import com.ibm.hwmca.fw.rbf.impl.RbfReply;
import com.ibm.hwmca.fw.util.Trace;
import java.util.HashSet;
import java.util.Set;

class HandlersMsg
implements RbfMsg {
    private static final String TRACE_MASKT = "XRBFHMST";
    private static final String TRACE_MASKF = "XRBFHMSF";
    private static final String TRACE_MASKD = "XRBFHMSD";
    private static final long serialVersionUID = -3822196488046751651L;
    private Set reqTypes;

    HandlersMsg(Set reqTypes) {
        this.reqTypes = reqTypes;
        Trace.trace(TRACE_MASKT, "<> HandlersMsg()");
    }

    Set getReqTypes() {
        return this.reqTypes;
    }

    public RbfReply process(MachineId sender2, int protocol) {
        Trace.trace(TRACE_MASKT, "-> process()");
        HandlersReply reply = null;
        if (sender2 != FcsServer.getFcsServer().getLocalMachineId()) {
            HandlerManager handlerMgr = HandlerManager.getHandlerManager();
            handlerMgr.addRemoteHandler(sender2, this.reqTypes);
            reply = new HandlersReply(handlerMgr.getLocalRequestTypes());
        } else {
            Trace.trace(TRACE_MASKF, "Sender is local machine");
            reply = new HandlersReply(new HashSet());
        }
        Trace.trace(TRACE_MASKT, "<- process()");
        return reply;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[HandlersMsg: reqTypesHandled=" + this.reqTypes.size() + "]");
        return sb.toString();
    }
}

